;	Disassembly of DISPLAY.COM
;
;	Version list - most recent version first
;
;26/Jul/82 Included conditional assembly for Keith Petersens patch that
;	will not accept wild-cards, distribution-tagged files, SYS files,
;	and files with '#' as the last character of the file type.
;	Compatible with CP/M 1.4 or 2.x. Added on line command help
;	display if "?" entered in response to command prompt. Bill Bolton
;
WBOOT	EQU	00000H
BDOS	EQU	00005H
FCB	EQU	05CH		;CP/M file control block
OPEN	EQU	15
;
ALF	EQU	0AH
ACR	EQU	0DH
EOF	EQU	01AH
;
VERS	EQU	11
;
FALSE	EQU	0
TRUE	EQU	NOT FALSE
;
RCPM	EQU	TRUE		;True for RCPM restricted version
;
	ORG	100H
;
	JMP	START
;
	DB	'Display Ver. '
	DB	VERS/10 + '0','.',VERS MOD 10 + '0'
	DB	', 24/Jul/1982$'
;
;Check for ambiguous file names
;
START:

	if	rcpm
	LXI	H,FCB		;POINT TO FCB
	MVI	B,11		;NO. OF CHARS TO CHECK
;
LOOP:
	INX	H		;POINT TO NEXT CHAR
	MOV	A,M		;GET CHAR
	CPI	'?'		;WAS IT A '?'
	JZ	WERROR		;YES, EXIT WITH ERROR MSG
	DCR	B		;ONE LESS TO CHECK
	JNZ	LOOP		;NOT DONE, GO GET MORE
;
;Check for private file type
;
	CPI	'#'		;WAS LAST CHARACTER A '#' ?
	JZ	OPENOT		;YES, PRINT ERROR AND EXIT
;
;Check for .COM file, which can't be printed
;
	CPI	'M'		;WAS LAST CHAR AN 'M'?
	JNZ	OBJCHK		;IF NOT, CHK FOR '.OBJ' TYPE
	DCX	H
	MOV	A,M		;CHK NEXT
	CPI	'O'		;AN 'O'?
	JNZ	OPENFIL		;IF NOT, GO OPEN FILE
	DCX	H
	MOV	A,M		;WAS 'O', CHK NEXT CHAR
	CPI	'C'		; 'C' AS IN '.COM'?
	JNZ	OPENFIL		;IF NOT, GO OPEN FILE
	CALL	ERXIT		;EXIT W/MESSAGE
	DB	'++CAN''T DISPLAY .COM FILES$'
;
;Check for .OBJ file, which can't be printed
;
OBJCHK:
	CPI	'J'		;WAS LAST CHAR AN 'J' THEN?
	JNZ	ALLCHK		;IF NOT, CHECK FOR '.ALL' TYPE
	DCX	H
	MOV	A,M		;MIGHT BE '.OBJ', CHK NEXT CHR
	CPI	'B'		;IS IT A 'B'?
	JNZ	OPENFIL		;IF NOT, GO OPEN FILE
	DCX	H
	MOV	A,M		;WAS, CHK FIRST CHAR
	CPI	'O'		; 'O' AS IN '.OBJ'?
	JNZ	OPENFIL		;IF NOT, GO OPEN FILE
	CALL	ERXIT		;EXIT W/MESSAGE
	DB	'++CAN''T DISPLAY .OBJ FILES$'
;
;Check for .ALL file, which can always be displayed
;
ALLCHK:
	CPI	'L'		;WAS LAST CHAR AN 'L'?
	JNZ	OPENFIL		;IF NOT, TRY AN OPEN
	DCX	H
	MOV	A,M		;CHK NEXT
	CPI	'L'		;AN 'L'?
	JNZ	OPENFIL		;IF NOT, GO OPEN FILE
	DCX	H
	MOV	A,M		;WAS 'L', CHK NEXT CHAR
	CPI	'A'		; 'A' AS IN '.ALL'?
	JNZ	OPENFIL		;IF NOT, GO OPEN FILE
	STA	ALLFLAG
;
;Open the file to get attributes into FCB
;
OPENFIL:
	LXI	D,FCB		;POINT TO FILE
	MVI	C,OPEN		;GET FUNCTION
	CALL	BDOS		;OPEN IT
	INR	A		;OPEN OK?
	JZ	ENTRY		;..NO, LET DISPLAY GIVE ERROR MSG
;
;Check for SYS file
;
	LDA	FCB+10		;GET SYS ATTRIBUTE
	ANI	80H		;ISOLATE ATTR BIT
	JNZ	OPENOT		;IT'S SYS, EXIT
;
;Check for distribution-protected (tagged) file
;
	LDA	FCB+2		;FIRST CHAR OF FILE NAME
	ANI	80H		;CHECK BIT 7
	JZ	ENTRY		;IT WAS OFF, EXIT TO DISPLAY
	LDA	ALLFLAG
	ORA	A		;IS AN '.ALL' FILE
	JNZ	ENTRY		;DISPLAY '.ALL' FILES EVEN IF TAGGED
;
OPENOT:
	CALL	ERXIT	;EXIT W/MESSAGE
	DB	'++FILE IS NOT FOR DISTRIBUTION, SORRY$'
;
WERROR:
	CALL	ERXIT
	DB	'++CAN''T USE WILD CARDS$'
;
;
;Exit with error message
;
ERXIT:
	POP	D	;GET MSG ADRS
	MVI	C,9 
	JMP	BDOS	;PRINT IT THEN RETURN TO CCP
;
	endif	;rcpm
;
ENTRY:
	LXI	SP,BUF$START	;Set up a stack (pointing to top)
	MVI	L,021H
	LXI	D,DFCB
	LXI	B,FCB
FCBLOOP:
	LDAX	B
	STAX	D
	INX	B
	INX	D
	DCR	L
	JNZ	FCBLOOP
A0134:
	CALL	INIT		;Set up data areas
	LXI	B,DFCB
	CALL	OPEN$FILE
	LDA	BDOS$VAL
	CPI	0FFH		;Succesful open?
	JNZ	A014E		;Yes
	LXI	B,NOT$FOUND$MSG	;No
	CALL	DISP$STRING	;Tell the user
	CALL	TO$WBOOT	;*** PERMANENT EXIT ***
;
A014E:
	LHLD	D077A
	MOV	B,H
	MOV	C,L
	CALL	A0387
	CALL	A0567
A0159:
	CALL	A06C3
	LDA	D0774
	CPI	ACR
	JNZ	A016D
	CALL	A0567
	JMP	A0159
;
; >> NO EXECUTION PATH TO HERE <<
	JMP	A0185
;
A016D:
	MVI	C,'B'
	CALL	A06EF
	RAR
	JNC	A0179
	JMP	A0134
;
A0179:
	MVI	C,'E'
	CALL	A06EF
	RAR
	JNC	QUERY
	CALL	TO$WBOOT	;*** PERMANENT EXIT ***
;
QUERY:
	MVI	C,'?'
	CALL	A06EF
	RAR
	JNC	A0185
	LXI	B,HELP$MSG
	CALL	DISP$STRING
	JMP	A0159
;	
A0185:
	LXI	H,D0777
	MVI	M,0
	LXI	H,1
	SHLD	D0784
	LDA	D0774
	CPI	'-'
	JNZ	A01A0
	LXI	H,D0777
	MVI	M,1
	CALL	A069F
A01A0:
	LDA	D0774
	SUI	'0'
	STA	D0778
	MOV	C,A
	MVI	A,9
	CMP	C
	JC	A01E7
	LHLD	D0778
	MVI	H,0
	SHLD	D0784
	CALL	A069F
A01BA:
	LDA	D0774
	SUI	'0'
	STA	D0778
	MOV	C,A
	MVI	A,9
	CMP	C
	JC	A01E7
	LHLD	D0784
	DAD	H
	DAD	H
	DAD	H
	PUSH	H
	LHLD	D0784
	DAD	H
	POP	B
	DAD	B
	PUSH	H
	LHLD	D0778
	MVI	H,0
	POP	B
	DAD	B
	SHLD	D0784
	CALL	A069F
	JMP	A01BA
;
A01E7:
	LDA	D0774
	CPI	'L'
	JNZ	A01FD
	LHLD	D0777
	MOV	C,L
	LHLD	D0784
	XCHG
	CALL	A0450
	JMP	A024D
;
A01FD:
	LDA	D0774
	CPI	'P'
	JNZ	A0237
	MVI	A,0
	LXI	D,D0784
	CALL	A0750
	ORA	L
	JZ	A022B
	LXI	D,017H
	LHLD	D0784
	CALL	A072F
	SHLD	D0784
	LHLD	D0777
	MOV	C,L
	LHLD	D0784
	XCHG
	CALL	A0450
	JMP	A0234
;
A022B:
	LHLD	D077A
	SHLD	D077E
	SHLD	D0786
A0234:
	JMP	A024D
;
A0237:
	LDA	D0774
	CPI	'D'
	JNZ	A024A
	LHLD	D0784
	MOV	B,H
	MOV	C,L
	CALL	A0595
	JMP	A024D
;
A024A:
	JMP	A0253
;
A024D:
	CALL	A0567
	JMP	A0159
;
A0253:
	LXI	B,ILLEGAL$MSG
	CALL	DISP$STRING
	JMP	A0159
;
; >> NO EXECUTION PATH TO HERE <<
	EI
	HLT
	LXI	D,0
	MVI	C,1		;Console input
	CALL	TO$BDOS
	RET
;
PUT$CHAR:
	LXI	H,D075C
	MOV	M,C
	LHLD	D075C
	MVI	H,0
	XCHG			;E <---- C
	MVI	C,2		;Console output
	CALL	TO$BDOS
	RET
;
; >> NO EXECUTION PATH TO HERE <<
	LXI	H,D075D
	MOV	M,C
	LHLD	D075D
	MVI	H,0
	XCHG
	MVI	C,5		;List output
	CALL	TO$BDOS
	RET
;
A0287:
	LXI	H,T075F
	MOV	M,B
	DCX	H
	MOV	M,C
	LHLD	D075E
	XCHG
	MVI	C,10		;Read console buffer
	CALL	TO$BDOS
	RET
;
OPEN$FILE:
	LXI	H,T0761
	MOV	M,B
	DCX	H
	MOV	M,C
	LHLD	D0760
	XCHG			;DE <---- BC
	MVI	C,15		;Open file
	CALL	TO$BDOS
	STA	BDOS$VAL	;Keep the result
	RET
;
; >> NO EXECUTION PATH TO HERE <<
	LXI	H,T0763
	MOV	M,B
	DCX	H
	MOV	M,C
	LHLD	D0762
	XCHG
	MVI	C,16		;Close file
	CALL	TO$BDOS
	STA	BDOS$VAL
	RET
;
; >> NO EXECUTION PATH TO HERE <<
	LXI	H,T0765
	MOV	M,B
	DCX	H
	MOV	M,C
	LHLD	D0764
	XCHG
	MVI	C,17		;Search first
	CALL	TO$BDOS
	SUI	0FFH
	ADI	0FFH
	SBB	A
	RET
;
; >> NO EXECUTION PATH TO HERE <<
	LXI	H,T0767
	MOV	M,B
	DCX	H
	MOV	M,C
	LHLD	D0766
	XCHG
	MVI	C,19		;Delete file
	CALL	TO$BDOS
	RET
;
A02E2:
	LXI	H,T0769
	MOV	M,B
	DCX	H
	MOV	M,C
	LHLD	D0768
	XCHG
	MVI	C,20		;Read sequential
	CALL	TO$BDOS
	STA	BDOS$VAL
	RET
;
; >> NO EXECUTION PATH TO HERE <<
	LXI	H,T076B
	MOV	M,B
	DCX	H
	MOV	M,C
	LHLD	D076A
	XCHG
	MVI	C,21		;Write sequential
	CALL	TO$BDOS
	STA	BDOS$VAL
	RET
;
; >> NO EXECUTION PATH TO HERE <<
	LXI	H,T076D
	MOV	M,B
	DCX	H
	MOV	M,C
	LHLD	D076C
	XCHG
	MVI	C,22		;Make file
	CALL	TO$BDOS
	RET
;
; >> NO EXECUTION PATH TO HERE <<
	LXI	D,0
	MVI	C,23		;Rename file
	CALL	TO$BDOS
	RET
;
; >> NO EXECUTION PATH TO HERE <<
	LXI	H,D076E
	MOV	M,C
	LHLD	D076E
	MVI	H,0
	XCHG
	MVI	C,14		;Select disk
	CALL	TO$BDOS
	RET
;
A0331:
	LXI	H,T0770
	MOV	M,B
	DCX	H
	MOV	M,C
	LHLD	D076F
	XCHG
	MVI	C,26		;Set DMA
	CALL	TO$BDOS
	RET
;
NEW$LINE:
	MVI	C,ALF
	CALL	PUT$CHAR
	MVI	C,ACR
	CALL	PUT$CHAR
	RET
;
DISP$STRING:
	LXI	H,T0772
	MOV	M,B
	DCX	H
	MOV	M,C
	LHLD	D0771
	XCHG			;DE <---- BC
	MVI	C,9		;Print string
	CALL	TO$BDOS
	CALL	NEW$LINE
	RET
;
INIT:
	LXI	H,D0773
	MVI	M,0
	LXI	H,BUF$START
	SHLD	D077A
	SHLD	D077E
	SHLD	D0780
	LHLD	D077A
	SHLD	D0786
	LXI	H,T0794
	MVI	M,0
	LXI	H,T07A8
	MVI	M,0
	LHLD	BDOS+1
	SHLD	D077C
	RET
;
A0387:
	LXI	H,Y082B
	MOV	M,B
	DCX	H
	MOV	M,C
	LDA	D0773
	RAR
	JC	A044F
	LHLD	Y082A
	SHLD	Y082C
	LXI	D,D077C
	CALL	A0753
	XCHG
	LXI	H,00080H
	CALL	A0710
	XCHG
	SHLD	Y082E
	LXI	H,BDOS$VAL
	MVI	M,000H
A03B0:
	MVI	A,0
	LXI	D,Y082E
	CALL	A0750
	ORA	L
	ADI	0FFH
	SBB	A
	PUSH	PSW
	LDA	BDOS$VAL
	SUI	000H
	SUI	001H
	SBB	A
	POP	B
	MOV	C,B
	ANA	C
	RAR
	JNC	A03EE
	LHLD	Y082C
	MOV	B,H
	MOV	C,L
	CALL	A0331
	LXI	B,DFCB
	CALL	A02E2
	LXI	D,00080H
	LHLD	Y082C
	DAD	D
	SHLD	Y082C
	LHLD	Y082E
	DCX	H
	SHLD	Y082E
	JMP	A03B0
;
A03EE:
	LDA	BDOS$VAL
	CPI	0
	JZ	A03FB
	LXI	H,D0773
	MVI	M,0FFH
A03FB:
	LHLD	Y082C
	SHLD	D0780
	LXI	B,00080H
	CALL	A0331
	LDA	D0773
	RAR
	JNC	A042F
	LXI	B,100H
	LXI	D,Y082C
	CALL	A0748
	XCHG
	DCX	H
	MOV	M,E
	INX	H
	MOV	M,D
A041C:
	LHLD	Y082C
	MOV	A,M
	CPI	EOF
	JZ	A042F
	LHLD	Y082C
	INX	H
	SHLD	Y082C
	JMP	A041C
;
A042F:
	LHLD	Y082C
	DCX	H
	SHLD	Y082C
A0436:
	LHLD	Y082C
	MOV	A,M
	CPI	00AH
	JZ	A0449
	LHLD	Y082C
	DCX	H
	SHLD	Y082C
	JMP	A0436
;
A0449:
	LHLD	Y082C
	SHLD	D0782
A044F:
	RET
;
A0450:
	LXI	H,Y0832
	MOV	M,D
	DCX	H
	MOV	M,E
	DCX	H
	MOV	M,C
	LDA	Y0830
	CPI	0
	JNZ	A049B
A0460:
	MVI	A,0
	LXI	D,Y0831
	CALL	A0750
	ORA	L
	ADI	0FFH
	SBB	A
	LXI	B,D0782
	LXI	D,D077E
	PUSH	PSW
	CALL	A0743
	SBB	A
	POP	B
	MOV	C,B
	ANA	C
	RAR
	JNC	A0498
	LHLD	D077E
	MOV	A,M
	CPI	ALF
	JNZ	A048E
	LHLD	Y0831
	DCX	H
	SHLD	Y0831
A048E:
	LHLD	D077E
	INX	H
	SHLD	D077E
	JMP	A0460
;
A0498:
	JMP	A04ED
;
A049B:
	LHLD	Y0831
	INX	H
	SHLD	Y0831
A04A2:
	MVI	A,0
	LXI	D,Y0831
	CALL	A0750
	ORA	L
	ADI	0FFH
	SBB	A
	LXI	D,D077A
	LXI	B,D077E
	PUSH	PSW
	CALL	A0743
	SBB	A
	POP	B
	MOV	C,B
	ANA	C
	RAR
	JNC	A04DA
	LHLD	D077E
	MOV	A,M
	CPI	ALF
	JNZ	A04D0
	LHLD	Y0831
	DCX	H
	SHLD	Y0831
A04D0:
	LHLD	D077E
	DCX	H
	SHLD	D077E
	JMP	A04A2
;
A04DA:
	LXI	D,D077A
	LXI	B,D077E
	CALL	A0743
	JNC	A04ED
	LHLD	D077E
	INX	H
	SHLD	D077E
A04ED:
	LHLD	D077E
	SHLD	D0786
	RET
;
A04F4:
	LXI	H,Y0834
	MVI	M,0
	LXI	B,D0782
	LXI	D,D077E
	CALL	A0743
	JNC	A0566
A0505:
	LHLD	D077E
	MOV	A,M
	STA	Y0833
	CPI	ALF
	JZ	A055A
	LDA	Y0833
	CPI	009H
	JZ	A0527
	LHLD	Y0833
	MOV	C,L
	CALL	PUT$CHAR
	LXI	H,Y0834
	INR	M
	JMP	A0550
;
A0527:
	LDA	Y0834
	ANI	007H
	MOV	C,A
	MVI	A,7
	SUB	C
	STA	Y0836
	LXI	H,Y0835
	MVI	M,0
A0538:
	LDA	Y0836
	LXI	H,Y0835
	CMP	M
	JC	A0550
	MVI	C,' '
	CALL	PUT$CHAR
	LXI	H,Y0834
	INR	M
	INX	H
	INR	M
	JNZ	A0538
A0550:
	LHLD	D077E
	INX	H
	SHLD	D077E
	JMP	A0505
;
A055A:
	LHLD	D077E
	INX	H
	SHLD	D077E
	MVI	C,ALF
	CALL	PUT$CHAR
A0566:
	RET
;
A0567:
	LHLD	D0786
	SHLD	Y0838
	SHLD	D077E
	LXI	H,Y0837
	MVI	M,1
A0575:
	MVI	A,017H
	LXI	H,Y0837
	CMP	M
	JC	A0588
	CALL	A04F4
	LXI	H,Y0837
	INR	M
	JNZ	A0575
A0588:
	LHLD	D077E
	SHLD	D0786
	LHLD	Y0838
	SHLD	D077E
	RET
;
A0595:
	LXI	H,Y083B
	MOV	M,B
	DCX	H
	MOV	M,C
	MVI	A,0
	LXI	D,Y083A
	CALL	A0750
	ORA	L
	JNZ	A05BC
	LXI	B,D077E
	LXI	D,D0780
	CALL	A0743
	SHLD	Y0840
	LHLD	D077E
	SHLD	Y083E
	JMP	A062B
;
A05BC:
	LHLD	D077A
	SHLD	Y083C
A05C2:
	MVI	A,0
	LXI	D,Y083A
	CALL	A0750
	ORA	L
	JZ	A0619
	LXI	H,00017H
	SHLD	Y0842
A05D4:
	MVI	A,0
	LXI	D,Y0842
	CALL	A0750
	ORA	L
	JZ	A060F
	LHLD	Y083C
	MOV	A,M
	CPI	ALF
	JNZ	A05F0
	LHLD	Y0842
	DCX	H
	SHLD	Y0842
A05F0:
	LHLD	Y083C
	INX	H
	SHLD	Y083C
	LXI	D,D0782
	CALL	A0753
	JNC	A060C
	LXI	H,0
	SHLD	Y0842
	LXI	H,1
	SHLD	Y083A
A060C:
	JMP	A05D4
;
A060F:
	LHLD	Y083A
	DCX	H
	SHLD	Y083A
	JMP	A05C2
;
A0619:
	LXI	B,Y083C
	LXI	D,D0780
	CALL	A0743
	SHLD	Y0840
	LHLD	Y083C
	SHLD	Y083E
A062B:
	LHLD	Y0840
	PUSH	H
	LHLD	Y083E
	MOV	B,H
	MOV	C,L
	LHLD	D077A
	XCHG
	POP	H
A0639:
	LDAX	B
	STAX	D
	INX	B
	INX	D
	DCX	H
	MOV	A,H
	ORA	L
	JNZ	A0639
	LXI	B,D077A
	LXI	D,Y083E
	CALL	A0743
	XCHG
	INX	H
	MOV	M,E
	INX	H
	MOV	M,D
	LXI	D,Y083E
	LXI	B,D077E
	CALL	A0743
	JNC	A066E
	LXI	B,Y0840
	LXI	D,D077E
	CALL	A0743
	XCHG
	DCX	H
	MOV	M,E
	INX	H
	MOV	M,D
	JMP	A0674
;
A066E:
	LHLD	D077A
	SHLD	D077E
A0674:
	LHLD	D077E
	SHLD	D0786
	LXI	B,Y0840
	LXI	D,D0780
	CALL	A0743
	XCHG
	DCX	H
	MOV	M,E
	INX	H
	MOV	M,D
	LXI	B,Y0840
	LXI	D,D0782
	CALL	A0743
	XCHG
	DCX	H
	MOV	M,E
	INX	H
	MOV	M,D
	LHLD	D0780
	MOV	B,H
	MOV	C,L
	CALL	A0387
	RET
;
A069F:
	LHLD	D0775
	MVI	H,0
	LXI	B,T07A9
	DAD	B
	MOV	A,M
	STA	D0774
	MOV	C,A
	MVI	A,'Z'
	CMP	C
	JNC	A06BB
	LDA	D0774
	ANI	0DFH
	STA	D0774
A06BB:
	LDA	D0775
	INR	A
	STA	D0775
	RET
;
A06C3:
	MVI	C,'*'
	CALL	PUT$CHAR
	LXI	B,T07A9
	CALL	A0287
	MVI	C,ALF
	CALL	PUT$CHAR
	LDA	D07AA
	STA	D0776
	CPI	0
	JNZ	A06E6
	LXI	H,D0774
	MVI	M,ACR
	JMP	A06EE
;
A06E6:
	LXI	H,D0775
	MVI	M,2
	CALL	A069F
A06EE:
	RET
;
A06EF:
	LXI	H,Y0844
	MOV	M,C
	LXI	H,Y0844
	LDA	D0774
	SUB	M
	SUI	1
	SBB	A
	PUSH	PSW
	LDA	D0776
	SUI	1
	SUI	1
	SBB	A
	POP	B
	MOV	C,B
	ANA	C
	RET
;
TO$BDOS:
	JMP	BDOS
;
TO$WBOOT:
	JMP	WBOOT
;
A0710:
	MOV	B,H
	MOV	C,L
	LXI	H,0
	MVI	A,010H
A0717:
	PUSH	PSW
	DAD	H
	XCHG
	SUB	A
	DAD	H
	XCHG
	ADC	L
	SUB	C
	MOV	L,A
	MOV	A,H
	SBB	B
	MOV	H,A
	INX	D
	JNC	A0729
	DAD	B
	DCX	D
A0729:
	POP	PSW
	DCR	A
	JNZ	A0717
	RET
;
A072F:
	MOV	B,H
	MOV	C,L
	LXI	H,0
	MVI	A,010H
A0736:
	DAD	H
	XCHG
	DAD	H
	XCHG
	JNC	A073E
	DAD	B
A073E:
	DCR	A
	JNZ	A0736
	RET
;
A0743:
	MOV	L,C
	MOV	H,B
	MOV	C,M
	INX	H
	MOV	B,M
A0748:
	LDAX	D
	SUB	C
	MOV	L,A
	INX	D
	LDAX	D
	SBB	B
	MOV	H,A
	RET
;
A0750:
	MOV	L,A
	MVI	H,0
A0753:
	LDAX	D
	SUB	L
	MOV	L,A
	INX	D
	LDAX	D
	SBB	H
	MOV	H,A
	RET
;
;
ALLFLAG	DB	0		;'.ALL' file type flag
BDOS$VAL:
	DB	06EH
D075C:	DB	006H
D075D:	DB	001H
D075E:	DB	040H
T075F:	DB	008H
D0760:	DB	011H
T0761:	DB	07EH
D0762:	DB	007H
T0763:	DB	0CDH
D0764:	DB	043H
T0765:	DB	007H
D0766:	DB	0EBH
T0767:	DB	02BH
D0768:	DB	073H
T0769:	DB	023H
D076A:	DB	072H
T076B:	DB	0C3H
D076C:	DB	074H
T076D:	DB	006H
D076E:	DB	02AH
D076F:	DB	07AH
T0770:	DB	007H
D0771:	DB	022H
T0772:	DB	07EH
D0773:	DB	007H
D0774:	DB	02AH
D0775:	DB	07EH
D0776:	DB	007H
D0777:	DB	022H
D0778:	DW	0
D077A:	DW	0
D077C:	DW	0
D077E:	DW	0
D0780:	DW	0
D0782:	DW	0
D0784:	DW	0
D0786:	DW	0
DFCB:	DB	0,0,0,0,0,0,0,0,0,0	;Internal FCB
	DB	0,0
T0794:	DB	0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0
T07A8:	DB	07EH
T07A9:	DB	080H
D07AA:	DB	000H
;
	DB	0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0
;
NOT$FOUND$MSG:
	DB	' FILE NOT FOUND$'
;
ILLEGAL$MSG:
	DB	' ILLEGAL COMMAND$'
;
HELP$MSG:
	DB	'DISPLAY Version '
	DB	VERS/10 + '0','.',VERS MOD 10 + '0'
	DB	' HELP SUMMARY',ACR,ALF,ACR,ALF
	DB	'Command:  Operation performed:',ACR,ALF
	DB	'=======   ===================',ACR,ALF
	DB	'B         Move pointer to beginning of file and display page.',ACR,ALF,ACR,ALF
	DB	'-nP       Move pointer minus n pages and display page.',ACR,ALF
	DB	'nP        Move pointer plus n pages and display page.',ACR,ALF
	DB	'0P        Move pointer to beginning of buffer and display page',ACR,ALF,ACR,ALF
	DB	'-nL       Move pointer minus n lines and display page.',ACR,ALF
	DB	'nL        Move pointer plus n lines and display page.',ACR,ALF
	DB	'nD        Discard n pages, refill buffer and display the',ACR,ALF
	DB	'          current page.',ACR,ALF
	DB	'0D        Discard all data up to the current pointer, refill',ACR,ALF
	DB	'          buffer and display the first page.',ACR,ALF,ACR,ALF
	DB	'E         Exit DISPLAY and return to CP/M.',ACR,ALF
	DB	'^C        Control-C, exit DISPLAY and return to CP/M.',ACR,ALF,ACR,ALF
	DB	'<cr>      Move pointer to next page and display',ACR,ALF
	DB	'$'
;
Y082A	DB	0
Y082B	DB	0
Y082C	DW	0
Y082E	DW	0
Y0830	DB	0
Y0831	DB	0
Y0832	DB	0
Y0833	DB	0
Y0834	DB	0
Y0835	DB	0
Y0836	DB	0
Y0837	DB	0
Y0838	DW	0
Y083A	DB	0
Y083B	DB	0
Y083C	DW	0
Y083E	DW	0
Y0840	DW	0
Y0842	DW	0
Y0844	DW	0
;
	DS	32
;
BUF$START EQU	$
;	
	END
